<?php

include 'lib/UnitPay.php';

class UnitPayEvent
{
    public function check($params)
    {
        /**
         * Проверка условий перед оплатой (например проверка заказа)
         *
         * return true; - Всё отлично, можно оплатить заказ
         * return 'Текст ошибки'; - Вернуть ошибку и завершить платеж
         *
         * Описание переменной $params
         *
         * $params['phone']
         * Десятизначный телефон плательщика (например, 9155743552).
         *
         * $params['account']
         * Идентификатор абонента в системе партнера (например логин или email абонента).
         *
         * $params['sum']
         * Сумма платежа (например, 10.00).
         */

        return true;
    }

    public function pay($params)
    {
        /**
         * Событие происходит сразу после успешной оплаты.
         * На этой стадии необходимо предоставить услугу/товар абоненту.
         *
         * Описание переменной $params
         *
         * $params['unitpayId']
         * Внутренний номер платежа в Unitpay.
         * Очень важно! В системе партнера не должно быть двух разных платежей с одним unitpayId.
         *
         * $params['account']
         * Идентификатор абонента в системе партнера (например логин или email абонента)
         *
         * $params['sum']
         * Сумма платежа (например, 10.00).
         *
         * $params['phone']
         * Десятизначный телефон плательщика (например, 9155743552).
         *
         * $params['paymentType']
         * Тип оплаты (sms — СМС Биллинг, mc — Мобильная коммерция)
         *
         * $params['operator']
         * Буквенный код оператора.
         *
         * $params['date']
         * Дата платежа в формате YYYY-mm-dd HH:ii:ss.
         *
         * $params['sign']
         * Цифровая подпись, образуется как md5 хеш от склеивания всех значений параметров (кроме sign),
         * отсортированных по алфавиту и секретного ключа 9d689864e8c34e077e2a4825d8d71a70
         */
    }
}

$payment = new UnitPay(
    new UnitPayEvent()
);

echo $payment->getResult();